new const NINTENDOMOD_PLUGIN[] = "Nintendo Mod Xtended"
new const NINTENDOMOD_VERSION[] = "3.5.2"
new const NINTENDOMOD_AUTHOR[] = "Soloist/Mephisto"

// DECIDE IF YOU WANT TO USE ULTIMATE STREAK
#define ULTIMATE_STREAK 1 // 1 = on, 0 = off
#define STREAKLEVELS 11

// EDIT THESE TO WHAT YOU WANT THEM TO BE
//#define SAVE_METHOD 	1			//Saves XP to vault.ini (default)
//#define SAVE_METHOD 	2			//Saves XP to nintendomod nVault
#define SAVE_METHOD 	3			//Saves XP to a MySQL database

#define NMADMIN 	ADMIN_LEVEL_A	// Admin Level
#define NINTENDO_MINPLAYERS	2	// minimum players online to receive XP
#define TASK_SAVEINIT 2000

//#define DEBUG
// DO NOT EDIT BELOW HERE

/*
	Description
		* This is a Counter-Strike Mod, that allows you to be
		* nintendo characters. Each character has two passives
		* that get better as you level. Three Skills with four
		* level, that increase the power of the skill, and One
		* PowerUp that can be selected above level six. With
		* Nintendo Mod it is easy to add and remove characters.
		* Each Character has its own saved XP.

	Required Modules:
    	* fakemeta
    	* cstrike
    	* hamsandwich	

	Client Commands:
		* say /changechar - Change your character
		* say /selectskills - Select your skills
		* say /resetskills - Reset your skills
		* say /playerlevels - Other players level
		* say /playerskills - Other players skill
		* say /skillsinfo - Current characters skills
		* say /characterhelp - Menu of all characters to see what they do
		* say /nintendohelp - Help menu
		* say /nintendomenu - Menu with all commands
		* +powerup - PowerUp command

	Admin Commands:
		* amx_givexp - Add xp to player
		* amx_takexp - Takes xp from player
		* amx_givelevel - Give Levels to player
		* amx_setlevel - Sets player level
		* amx_resetxp - resets the xp

	CVARs:
		* sv_nintendomod - 1 = On, 0 = Off
		* nm_teamkill - 1 = on, 0 = off
		* nm_version

	Future Plans
		*

	Based on Soloist's original source code Nintendo Mod v3.1, updated by Mephisto
	Version 3.5.2
	Last Updated On 06/09/09

	*************************************************************************************

	Changelog
		Version 3.5.2
			* new streak sounds/messages
			* kill assists fixed, now also working on ExtraDamage
		Version 3.5.1
			* MySql injection protection added (old one was crappy)
		Version 3.5
			* fixed MySql load bug, ensures now that config file is executed first
			* "/changerace" added to say-commands to change char (easier for WC3 players)
		Version 3.4.2
			* plugin title changed
		Version 3.4.1
			* additional details about kills in console
		Version 3.4
			* forces cl_minmodel 0
			* streak-kill bonuses, kill assists, fairer xp distribution to a player's team for single events
			* lvl cap increased to 15
			* new xp-events
		Version 3.1
			* When hostages are rescued the whole teams gets exp
			* When bomb detonate the whole teams gets exp
		Version 3.0.1
			* Fixed bug that crashed mod
		Version 3.0
			* Fixed Admin commands, they no longer say "Unknown command:"
			* Fixed Admin commands, Setlevel and GiveLevel, now actually give level to the right person.
			* Added hud for when you look at a player.
			* Added many built in functions.
		Version 2.5
			* Added nVault Support
			* Hopefully fixed MySql bug
			* Added one round delay on loading XP
			* Fixed HUD
		Version 2.0
			* Fix Sql Bug
			* Allowed it to be played with DM
		Version 1.5
			* Added MySql Support
			* Added Client Command /playerlevels
			* Fix bug where plugin can load itself twice
			* Added NMADMIN for Admin access to commands
			* Sound for powerup only play on client and not all.
		Version 1.0
			* Release of the plugin
*/

#include <amxmodx>
#include <amxmisc>
#include <cstrike>
#include <fakemeta>
#include <nintendomod>

new const LEVELS[15] = {100, 200, 400, 800, 1600, 3200, 6400, 12800, 25600, 51200, 102400, 128000, 160000, 200000, 250000};
new const XPGIVEN[16] = {4, 6, 8, 9, 10, 11, 12, 12, 12, 12, 14, 16, 17, 18, 19, 20};
new const MOTD_HEADER[] = "<html><head><style type=^"text/css^">p{color:#FFFF00; font-size:12px;}h1{color:#FFFF00;font-size:18px;}h2{color:#FFFF00;font-size:16px;}body{background:#000000;color:#FFFF00;margin-left:8px;margin-top:0px;}</style></head><body><p><br />";
new const MOTD_FOOTER[] = "</p></body></html>";
new Float:wpn_multiplier[33] = {1.0};

new AllChars[MAXCHARS][33];
new AllPassive[MAXCHARS][33];
new AllPassive2[MAXCHARS][33];
new AllSkill1[MAXCHARS][33];
new AllSkill2[MAXCHARS][33];
new AllSkill3[MAXCHARS][33];
new AllPowerUp[MAXCHARS][33];
new AllInit[MAXCHARS][33];
new NumAllChars = 0;

new AllKeyDown[MAXCHARS][33];
new AllKeyUp[MAXCHARS][33];

new AllPassiveHelp[MAXCHARS][512];
new AllPassive2Help[MAXCHARS][512];
new AllSkill1Help[MAXCHARS][512];
new AllSkill2Help[MAXCHARS][512];
new AllSkill3Help[MAXCHARS][512];
new AllPowerUpHelp[MAXCHARS][512];
new NumAllHelp = 0;

new PlayerChar[33];
new PlayerXP[MAXCHARS][33];
new PlayerLevel[MAXCHARS][33];
new PlayerSkill1[MAXCHARS][33];
new PlayerSkill2[MAXCHARS][33];
new PlayerSkill3[MAXCHARS][33];
new PlayerPowerUp[MAXCHARS][33];

new UltimateStreak = ULTIMATE_STREAK;
new bool:resetskills[33];
new bool:PowerUpUsed[33];
new PowerUpTime[33];

new NewPlayerChar[33];
new kills[33] = {0,...};
new deaths[33] = {0,...};
new streaklevels[11] = {3, 5, 7, 9, 11, 15, 17, 19, 21, 23, 25};
new stksounds[11][] = {"misc/multikill", "misc/ultrakill", 
				"misc/monsterkill", "misc/killingspree", "misc/godlike", "misc/masterkiller",
				"misc/f_dominating", "misc/f_rampage", "misc/f_unstoppable", "misc/f_holyshit", "misc/f_wickedsick"};
new stkmessages[11][] = {"%s: Multi-Kill!", "%s: Ultra-Kill!!!", "%s: Monster-kill!!!",
				"%s IS ON A KILLING SPREE!!!", "%s IS GODLIKE." , "%s IS THE MASTER KILLER!!!",
				"%s IS DOMINATING!!", "%s IS ON RAMPAGE!!", "%s IS UNSTOPPABLE!!!",
				"%s ... HOLYSHIT!!!", "%s IS WICKED SICK!!!"};
new DamageDone[33][33];

new bool:BetweenRounds;
new gBlockDeathMsg = 0, gInBlock = 0;

new nintendoMenuOffset[33], characterMenuOffset[33];

#if SAVE_METHOD == 1 || !defined SAVE_METHOD
#include <nintendomod_vault>	//Saves XP to vault.ini (default)
#endif

#if SAVE_METHOD == 2
#include <nintendomod_nvault>	//Saves XP to nintendomod nVault (AMXX recommended)
#endif

#if SAVE_METHOD == 3
#include <nintendomod_mysql>	//Saves XP to a MySQL database
#endif

public plugin_init()
{
	if(is_plugin_loaded("Nintendo Mod Xtended") > 0)
	{
		server_print("*******************************************");
		server_print("*** You can only load Nintendo Mod once ***");
		server_print("*******************************************");
		pause("ae");
		return;
	}

	register_plugin(NINTENDOMOD_PLUGIN, NINTENDOMOD_VERSION, NINTENDOMOD_AUTHOR);
	register_cvar("NintendoMod_Version", NINTENDOMOD_VERSION, FCVAR_SERVER|FCVAR_SPONLY);
	set_cvar_string("NintendoMod_Version", NINTENDOMOD_VERSION);

	register_cvar("sv_nintendomod", "1");
	register_cvar("nm_teamkill", "0");
	register_cvar("nm_version", NINTENDOMOD_VERSION);
#if SAVE_METHOD == 3
	register_cvar("nm_mysql_host", "", FCVAR_PROTECTED);
	register_cvar("nm_mysql_user", "", FCVAR_PROTECTED);
	register_cvar("nm_mysql_pass", "", FCVAR_PROTECTED);
	register_cvar("nm_mysql_db", "", FCVAR_PROTECTED);
#endif

	// Load config
	new configs[128];
	get_configsdir(configs, 127);
	server_cmd("exec %s/NintendoMod/nintendomod.cfg", configs);

	set_task(0.7, "Saving_Init", TASK_SAVEINIT);
	XP_Configure();

	register_menu("Nintendo Menu", 1023, "NintendoMenu");
	register_menu("Choose Character", 1023, "ChooseCharacter");
	register_menu("Choose Skill", 1023, "ChooseSkill");
	register_menu("Character Help", 1023, "CharacterHelp");

	register_event("Damage", "DamageDealt", "b", "2!0");
	register_event("DeathMsg", "DeathMsg", "ae");
	register_event("ResetHUD", "ResetHUD", "b");
	register_event( "SendAudio", "on_TerroristWin", "a", "2=%!MRAD_terwin");
	register_event( "SendAudio", "on_CTWin", "a", "2=%!MRAD_ctwin");
	register_event( "StatusValue", "ShowStatus", "be", "1=2", "2!0");
	register_event( "StatusValue", "HideStatus", "be", "1=1", "2=0");

	register_concmd("amx_givexp", "Admin_GiveXP", NMADMIN, " - Add xp to player");
	register_concmd("amx_takexp", "Admin_TakeXP", NMADMIN, " - Takes xp from player");
	register_concmd("amx_givelevel", "Admin_GiveLevel", NMADMIN, " - Give Levels to player");
	register_concmd("amx_setlevel", "Admin_SetLevel", NMADMIN, " - Sets player level");
	register_concmd("amx_resetxp", "Admin_ResetXP", NMADMIN, " - resets the xp");

	register_clcmd("say", "HandleSay");
	register_clcmd("say_team", "HandleSay");
	register_clcmd("nintendomenu", "ShowNintendoMenu");

	register_clcmd("+powerup", "PowerUpKeyDown");
	register_clcmd("-powerup", "PowerUpKeyUp");

	register_clcmd("fullupdate", "FullUpdate");

	register_forward(FM_MessageBegin, "hook_messagebegin");
	register_forward(FM_WriteByte, "hook_writebyte");
	register_forward(FM_WriteChar, "hook_writechar")
	register_forward(FM_WriteShort, "hook_writeshort");
	register_forward(FM_WriteLong, "hook_writelong");
	register_forward(FM_WriteAngle, "hook_writeangle");
	register_forward(FM_WriteCoord, "hook_writecoord");
	register_forward(FM_WriteString, "hook_writestring");
	register_forward(FM_WriteEntity, "hook_writeent");
	register_forward(FM_MessageEnd, "hook_messageend");
}

public plugin_precache()
{
	new soundfile[65];
	engfunc(EngFunc_PrecacheSound, "nintendomod/powerup.wav");
	engfunc(EngFunc_PrecacheSound, "nintendomod/powerupfail.wav");
	engfunc(EngFunc_PrecacheSound, "nintendomod/powerupdeny.wav");
	
	// precache streak sounds
	for(new i=0; i<STREAKLEVELS; i++)
	{
		formatex(soundfile, 64, "%s.wav", stksounds[i]);
		precache_sound(soundfile);
	}

	precache_sound("misc/humiliation.wav")
	precache_sound("misc/headshot.wav")
	precache_sound("misc/maytheforce.wav")
	precache_sound("misc/oneandonly.wav")
}

public plugin_cfg()
{
	set_task(1.0, "TimerAll", 0, "", 0, "b");
}

public plugin_modules()
{
	require_module("cstrike");
	require_module("fakemeta");
#if SAVE_METHOD == 1 || !defined SAVE_METHOD
	require_module("vault");
#endif

#if SAVE_METHOD == 2
	require_module("nvault");
#endif

#if SAVE_METHOD == 3
	require_module("mysql");
#endif
}

public plugin_natives()
{
	register_native("Nintendo_RegisterChar", "native_RegisterChar");
	register_native("Nintendo_RegisterHelp", "native_RegisterHelp");
	register_native("Nintendo_RegisterKeyDown", "native_RegisterKeyDown");
	register_native("Nintendo_RegisterKeyUp", "native_RegisterKeyUp");
	register_native("Nintendo_GetUserChar", "native_GetUserChar");
	register_native("Nintendo_PowerUpUsed", "native_PowerUpUsed");
	register_native("Nintendo_PowerUpDeny", "native_PowerUpDeny");
	register_native("Nintendo_ExtraDamage", "native_ExtraDamage");
}

public plugin_log()
{
	new logdata0[128], logdata1[64], logdata2[64], logdata3[64];
	new name[32], id;

	//Get the args from the log data
	read_logargv(0, logdata0, 127);
	read_logargv(1, logdata1, 63);
	read_logargv(2, logdata2, 63);
	read_logargv(3, logdata3, 63);

	if(CheckEnoughPlayers())
	{
		//Individual Events
		if(equal(logdata1, "triggered"))
		{
			//Get the username and id out
			parse_loguser(logdata0, name, 31);
			id = get_user_index(name);

			//Hostage Events
			if(equal(logdata2, "Rescued_A_Hostage"))
			{
				client_print(id, print_chat, "[Nintendo Mod] You just earned %dXP for rescuing a hostage", (PlayerLevel[id][PlayerChar[id]] >= 10 ? 25:15));
				if(PlayerLevel[id][PlayerChar[id]] >= 10)
					AddXP(id, 25);
				else
					AddXP(id, 15);
				AddTeamXP(CS_TEAM_CT, 10, "[Nintendo Mod] You just earned 10XP for helping to rescue a hostage", id);
			}
			else if(equal(logdata2, "Touched_A_Hostage"))
			{
				client_print(id, print_chat, "[Nintendo Mod] You just earned %dXP for talking to a hostage", (PlayerLevel[id][PlayerChar[id]] >= 10 ? 7:5));
				if(PlayerLevel[id][PlayerChar[id]] >= 10)
					AddXP(id, 7);
				else
					AddXP(id, 5);
			}
			else if(equal(logdata2, "Killed_A_Hostage"))
			{
				client_print(id, print_chat, "[Nintendo Mod] You just lost 15XP for killing a hostage");
				AddXP(id, -15);
			}
			//Bomb Events
			else if(equal(logdata2, "Planted_The_Bomb"))
			{
				client_print(id, print_chat, "[Nintendo Mod] You just earned %dXP for planting the bomb", (PlayerLevel[id][PlayerChar[id]] >= 10 ? 30:20));
				if(PlayerLevel[id][PlayerChar[id]] >= 10)
					AddXP(id, 30);
				else
					AddXP(id, 20);
				AddTeamXP(CS_TEAM_T, 10, "[Nintendo Mod] You just earned 10XP for helping to plant the bomb", id);
			}
			else if(equal(logdata2, "Defused_The_Bomb"))
			{
				client_print(id, print_chat, "[Nintendo Mod] You just earned %dXP for defusing the bomb", (PlayerLevel[id][PlayerChar[id]] >= 10 ? 30:20));
				if(PlayerLevel[id][PlayerChar[id]] >= 10)
					AddXP(id, 30);
				else
					AddXP(id, 20);
				AddTeamXP(CS_TEAM_CT, 10, "[Nintendo Mod] You just earned 10XP for helping to defuse the bomb", id);
			}
			// VIP Events
			else if(equal(logdata2, "VIP_Assassinated"))
			{
				client_print(id, print_chat, "[Nintendo Mod] You just earned %dXP for assassinating the VIP", (PlayerLevel[id][PlayerChar[id]] >= 10 ? 30:20));
				if(PlayerLevel[id][PlayerChar[id]] >= 10)
					AddXP(id, 30);
				else
					AddXP(id, 20);
				AddTeamXP(CS_TEAM_T, 10, "[Nintendo Mod] You just earned 10XP for helping to assassinate the VIP", id);
			}
			else if(equal(logdata2, "Escaped_As_VIP"))
			{
				client_print(id, print_chat, "[Nintendo Mod] You just earned %dXP for escaping as VIP", (PlayerLevel[id][PlayerChar[id]] >= 10 ? 30:20));
				if(PlayerLevel[id][PlayerChar[id]] >= 10)
					AddXP(id, 30);
				else
					AddXP(id, 20);
				AddTeamXP(CS_TEAM_CT, 10, "[Nintendo Mod] You just earned 10XP for helping the VIP to escape", id);
			}
		}

		//Team Events
		else if(equal(logdata3,"All_Hostages_Rescued"))
			AddTeamXP(CS_TEAM_CT, 25, "[Nintendo Mod] You just earned 25XP for rescuing all the hostages", -1);
		else if(equal(logdata3,"Hostages_Not_Rescued"))
			AddTeamXP(CS_TEAM_T, 25, "[Nintendo Mod] You just earned 25XP for preventing the hostages' rescue", -1);
		else if(equal(logdata3,"Target_Bombed"))
			AddTeamXP(CS_TEAM_T, 25, "[Nintendo Mod] You just earned 25XP for bombing the target", -1);
		else if(equal(logdata3,"Target_Saved"))
			AddTeamXP(CS_TEAM_CT, 25, "[Nintendo Mod] You just earned 25XP for saving the target", -1);
		else if(equal(logdata3,"VIP_Escaped"))
			AddTeamXP(CS_TEAM_CT, 25, "[Nintendo Mod] You just earned 25XP for the VIP could escape", -1);
		else if(equal(logdata3,"VIP_Not_Escaped"))
			AddTeamXP(CS_TEAM_T, 25, "[Nintendo Mod] You just earned 25XP for preventing the VIP's escape", -1);
	}
}
// Client Connects and Disconnects
public client_putinserver(id)
{
	InitPlayer(id);
	set_task(0.1, "ShowHUD", id, _, _, "b");
	set_task(5.0, "CheckMinmodels", id);
	kills[id] = 0;
	deaths[id] = 0;
}

public client_disconnect(id)
{
	for (new i=0; i<33; i++)
		DamageDone[id][i] = 0;
	SaveXPAll(id);
	InitPlayer(id);
	remove_task(id);
}

public CheckMinmodels(id)
{
	if(!Nintendo_Active())
		return PLUGIN_HANDLED;

	query_client_cvar(id, "cl_minmodels", "cvar_minmod");
	set_task(5.0, "CheckMinmodels", id);

	return PLUGIN_CONTINUE;
}

public cvar_minmod(id, const cvar[], const value[])
{
	if(equal(value, "1"))
	{
		client_print(id, print_console, "This server does not allow minmodels, set cl_minmodels 0");
		client_print(id, print_chat, "This server does not allow minmodels, set cl_minmodels 0");
		client_cmd(id, "cl_minmodels 0; kill");
	}

	return PLUGIN_CONTINUE;
}

public RoundStart()
{
	if(!Nintendo_Active())
		return PLUGIN_HANDLED;

	BetweenRounds = false;

	return PLUGIN_CONTINUE;
}

public RoundEnd()
{
	if(!Nintendo_Active())
		return PLUGIN_HANDLED;

	BetweenRounds = true;

	return PLUGIN_CONTINUE;
}
// Init Player
public InitPlayer(id)
{
	if(!is_user_connected(id))
		return PLUGIN_HANDLED;

	PlayerChar[id] = CLASS_NONE;
	NewPlayerChar[id] = -1;
	resetskills[id] = false;

	set_task(2.0, "LoadXP", id);
	set_task(2.5, "InitAllCharacter", id);

	for(new i = 1; i < MAXCHARS; i++)
	{
		PlayerLevel[id][i] = 0;
		PlayerXP[id][i] = 0;
		PlayerSkill1[id][i] = 0;
		PlayerSkill2[id][i] = 0;
		PlayerSkill3[id][i] = 0;
		PlayerPowerUp[id][i] = 0;
	}

	return PLUGIN_CONTINUE;
}

public InitAllCharacter(id)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	for(new i = 0; i < NumAllChars; i++)
		server_cmd("%s %d %d %d %d %d %d %d", AllInit[i], id, 0, PlayerLevel[id][i], PlayerSkill1[id][i], PlayerSkill2[id][i], PlayerSkill3[id][i], PlayerPowerUp[id][i]);

	return PLUGIN_CONTINUE;
}

public InitCharacter(id)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	new player = PlayerChar[id];

	server_cmd("%s %d %d %d %d %d %d %d", AllInit[player], id, 0, PlayerLevel[id][player], PlayerSkill1[id][player], PlayerSkill2[id][player], PlayerSkill3[id][player], PlayerPowerUp[id][player]);

	return PLUGIN_CONTINUE;
}

public InitLevel(id)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	new player = PlayerChar[id];

	server_cmd("%s %d %d %d", AllInit[player], id, 1, PlayerLevel[id][player]);

	return PLUGIN_CONTINUE;
}

public InitSkill(id, index, value)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	new player = PlayerChar[id];

	server_cmd("%s %d %d %d", AllInit[player], id, index, value);

	return PLUGIN_CONTINUE;
}
// HUD
public ShowHUD(id)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	new HUD[251];

	if(PlayerLevel[id][PlayerChar[id]] < 15)
		format(HUD, 250, "[Nintendo Mod] %s - Level: %i - XP: %i/%i", AllChars[PlayerChar[id]], PlayerLevel[id][PlayerChar[id]], PlayerXP[id][PlayerChar[id]], LEVELS[PlayerLevel[id][PlayerChar[id]]]);
	else
		format(HUD, 250, "[Nintendo Mod] %s - Level: %i - XP: %i", AllChars[PlayerChar[id]], PlayerLevel[id][PlayerChar[id]], PlayerXP[id][PlayerChar[id]]);

	message_begin(MSG_ONE, get_user_msgid("StatusText"), {0,0,0}, id);
	write_byte(0);
	write_string(HUD);
	message_end();

	return PLUGIN_CONTINUE;
}

public ResetHUD(id)
{
	if(!Nintendo_Active())
		return PLUGIN_HANDLED;

	for (new i=0; i<33; i++)
		DamageDone[id][i] = 0;

	if(PlayerChar[id] == CLASS_NONE)
		set_task(0.3, "ShowCharacter", id);

	if(!Nintendo_IsValidPlayer(id, true))
		return PLUGIN_HANDLED;

	if(NewPlayerChar[id] != -1)
	{
		SaveXP(id);

		PlayerChar[id] = NewPlayerChar[id];
		InitCharacter(id);
		ShowLevel(id);
		NewPlayerChar[id] = -1;
	}

	if(PlayerPowerUp[id][PlayerChar[id]] >= 1)
	{
		PowerUpUsed[id] = true;
		PowerUpTime[id] = 10;
	}

	if (kills[id] > streaklevels[0])
		client_print(id, print_chat, "* You are on a killstreak with %d kills.", kills[id]);
	else if (deaths[id] > 1)
		client_print(id, print_chat, "* Take care, you are on a deathstreak with %d deaths in a row.", deaths[id]);

	if(resetskills[id])
		ResetSkills(id);
	new skillsused = PlayerSkill1[id][PlayerChar[id]] + PlayerSkill2[id][PlayerChar[id]] + PlayerSkill3[id][PlayerChar[id]] + PlayerPowerUp[id][PlayerChar[id]]
	if(skillsused < PlayerLevel[id][PlayerChar[id]])
		ShowSkill(id);

//	CheckShopItems(id);

	return PLUGIN_CONTINUE;
}

public DamageDealt(id)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id, true))
		return PLUGIN_HANDLED;

	new weapon, bodypart, attacker = get_user_attacker(id, weapon, bodypart);

	if(Nintendo_IsValidPlayer(attacker, true) && attacker != id)
	{
		new damage = read_data(2);
		DamageDone[id][attacker] += damage;
	}

	return PLUGIN_CONTINUE;
}

public DeathMsg()
{
	if(!Nintendo_Active())
		return PLUGIN_HANDLED;

	new attacker = read_data(1);
	new victim = read_data(2);
	new headshot  = read_data(3);
	kills[victim] = 0;

	if(attacker && victim && attacker != victim)
	{
		new clip, ammo;
		new weapon = get_user_weapon(attacker, clip, ammo);

		if(get_user_team(attacker) == get_user_team(victim))
		{
			kills[attacker] = 0;
			AddXP(attacker, -10);
		}
		else
		{
			new Float:streak_multiplier = 1.0;
			if(UltimateStreak)
			{
				kills[attacker] += 1;
				kills[victim] = 0;
				deaths[attacker] = 0;
				deaths[victim] += 1;
				streak_multiplier = floatpower(1.02, float(kills[attacker] - 1));
				
				for(new i=0; i<STREAKLEVELS; i++)
					if (kills[attacker] == streaklevels[i])
					{
						announce(attacker, i);
						break;
					}
			}
			new Float:hs_multiplier = (headshot ? 1.5 : 1.0);

			new Float:multiplier = streak_multiplier * hs_multiplier * wpn_multiplier[weapon];
			new experience = floatround(float(XPGIVEN[PlayerLevel[victim][PlayerChar[victim]]]) * multiplier);
			if(PlayerLevel[attacker][PlayerChar[attacker]] >= 10)
				experience = floatround(float(experience) * (1.0 - (PlayerLevel[attacker][PlayerChar[attacker]]-9)*0.04), floatround_floor);
			AddXP(attacker, experience);
			client_print(attacker, print_console, "[Nintendo Mod] %d XP for a kill (streak: %d kills >> +%.1f%s, weapon: +%d%s%s)", experience, kills[attacker], 100*(streak_multiplier-1), "%%", floatround(100*(wpn_multiplier[weapon]-1)), "%%", (headshot ? ", hs: +50%%" : ""));
			// Kill Assist
			for(new i=1; i<33; i++)
			{
				if(i != attacker && DamageDone[victim][i] && Nintendo_IsValidPlayer(i))
				{
					new victimMaxHealth = pev(victim, pev_max_health);
					new Float:assist_multiplier = float(DamageDone[victim][i]) / float(victimMaxHealth);
					new assist_xp = floatround(float(experience) * assist_multiplier);
					client_print(i, print_chat, "[Nintendo Mod] You just earned %dXP for a kill assist", assist_xp);
					AddXP(i, assist_xp);
					DamageDone[victim][i] = 0;
				}
			}
		}
	}

	return PLUGIN_CONTINUE
}

public announce(killer, level)
{
	new name[32];

	get_user_name(killer, name, 32);
	set_hudmessage(0, 100, 200, 0.05, 0.65, 2, 0.02, 6.0, 0.01, 0.1, 2);
	show_hudmessage(0, stkmessages[level], name);

	client_cmd(0, "spk %s", stksounds[level]);
	
	return PLUGIN_CONTINUE;
}

// Nintendo Menu
public ShowNintendoMenu(id, menuOffset)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id) || (get_user_team(id) != 1 && get_user_team(id) != 2))
		return PLUGIN_HANDLED;

	nintendoMenuOffset[id] = 0;

	new nintendoMenu[1801];
	new nintendoKeys;

	nintendoMenuOffset[id] = menuOffset;

	switch(menuOffset)
	{
		case 0:
		{
			new len = format(nintendoMenu, 1800, "\rNintendo Menu^n^n");
			len += format(nintendoMenu[len], 1800-len, "\r1. \wCharacter Menu^n");
			len += format(nintendoMenu[len], 1800-len, "\r2. \wSkills Menu^n");
			len += format(nintendoMenu[len], 1800-len, "\r3. \wHelp^n");
			if(get_user_flags(id) & NMADMIN)
			{
				len += format(nintendoMenu[len], 1800-len, "\r4. \wAdmin Menu^n^n");
				nintendoKeys |= MENU_KEY_4
			}
			else
				len += format(nintendoMenu[len], 1800-len, "^n");

			len += format(nintendoMenu[len], 1800-len, "\r0. \wExit^n");

			nintendoKeys |= MENU_KEY_1|MENU_KEY_2|MENU_KEY_3|MENU_KEY_0;
		}
		case 1:
		{
			new len = format(nintendoMenu, 1800, "\rCharacter Menu^n^n");
			len += format(nintendoMenu[len], 1800-len, "\r1. \wChange Character^n");
			len += format(nintendoMenu[len], 1800-len, "\r2. \wShow Level^n");
			len += format(nintendoMenu[len], 1800-len, "\r3. \wReset XP to 0^n");
			len += format(nintendoMenu[len], 1800-len, "\r4. \wShow Player Skills^n^n");
			len += format(nintendoMenu[len], 1800-len, "\r9. \wBack^n");
			len += format(nintendoMenu[len], 1800-len, "\r0. \wExit^n");

			nintendoKeys |= MENU_KEY_1|MENU_KEY_2|MENU_KEY_3|MENU_KEY_4|MENU_KEY_9|MENU_KEY_0;
		}
		case 2:
		{
			new len = format(nintendoMenu, 1800, "\rSkills Menu^n^n");
			len += format(nintendoMenu[len], 1800-len, "\r1. \wSelect Skills^n");
			len += format(nintendoMenu[len], 1800-len, "\r2. \wSkills Information^n");
			len += format(nintendoMenu[len], 1800-len, "\r3. \wReset Skills^n^n");
			len += format(nintendoMenu[len], 1800-len, "\r9. \wBack^n");
			len += format(nintendoMenu[len], 1800-len, "\r0. \wExit^n");

			nintendoKeys |= MENU_KEY_1|MENU_KEY_2|MENU_KEY_3|MENU_KEY_9|MENU_KEY_0;
		}
		case 3:
		{
			new len = format(nintendoMenu, 1800, "\rAdmin Menu^n^n");
			len += format(nintendoMenu[len], 1800-len, "\r1. \wGive Player XP^n");
			len += format(nintendoMenu[len], 1800-len, "\r2. \wGive Team XP^n");
			len += format(nintendoMenu[len], 1800-len, "\r3. \wSave everyone's XP^n^n");
			len += format(nintendoMenu[len], 1800-len, "\r9. \wBack^n");
			len += format(nintendoMenu[len], 1800-len, "\r0. \wExit^n");

			nintendoKeys |= MENU_KEY_1|MENU_KEY_2|MENU_KEY_3|MENU_KEY_9|MENU_KEY_0;
		}
	}

	show_menu(id, nintendoKeys, nintendoMenu, -1, "Nintendo Menu");

	return PLUGIN_HANDLED;
}

public NintendoMenu(id, key)
{
	if(key == 9)
	{
		nintendoMenuOffset[id] = 0;
		return PLUGIN_HANDLED;
	}

	switch(nintendoMenuOffset[id])
	{
		case 0:
		{
			switch(key)
			{
				case 0: ShowNintendoMenu(id, 1);
				case 1: ShowNintendoMenu(id, 2);
				case 2: ShowNintendoMenu(id, 3);
				case 3: PlayerHelp(id);
				case 4: ShowNintendoMenu(id, 4);
			}
		}
		case 1:
		{
			switch(key)
			{
				case 0: ShowCharacter(id, 1);
				case 1: ShowLevel(id);
				case 2: ResetXP(id, PlayerChar[id]);
				case 3: PlayerSkills(id);
				case 8: ShowNintendoMenu(id, 0);
			}
		}
		case 2:
		{
			switch(key)
			{
				case 0: CheckSkills(id);
				case 1: SkillsInfo(id);
				case 2: SetResetSkills(id);
				case 8: ShowNintendoMenu(id, 0);
			}
		}
		case 3:
		{
			switch(key)
			{
				//case 0: //Give Player XP
				//case 1: //Give TeamXP
				case 2:
				{
					for(new i = 1; i < get_playersnum(); i++)
					{
						if(Nintendo_IsValidPlayer(i))
							SaveXPAll(i);
					}
				}
				case 8: ShowNintendoMenu(id, 0);
			}
		}
	}

	return PLUGIN_CONTINUE;
}
// Choosing Character
public ShowCharacter(id, menuOffset)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id) || (get_user_team(id) != 1 && get_user_team(id) != 2))
		return PLUGIN_HANDLED;

	characterMenuOffset[id] = 0;

	new charMenu[1801];
	new charKeys;

	if(menuOffset <= 0 || menuOffset > NumAllChars)
		menuOffset = 1;

	characterMenuOffset[id] = menuOffset;

	new len = format(charMenu, 1800, "\rNintendo Mod\r^n");
	len += format(charMenu[len], 1800-len, "\y%-25s %s^n^n", "Character", "XP");

	for(new x = menuOffset; x < menuOffset + 8; x++)
	{
		if(equali(AllChars[x], ""))
		{
			len += format(charMenu[len], 1800-len, "^n");
			continue;
		}

		if(PlayerChar[id] == x)
			len += format(charMenu[len], 1800-len, "\d%d. %-20s %d^n", x-menuOffset+1, AllChars[x], PlayerXP[id][x]);
		else
			len += format(charMenu[len], 1800-len, "\r%d. \w%-20s %d^n", x-menuOffset+1, AllChars[x], PlayerXP[id][x]);

		charKeys |= (1<<x-menuOffset);
	}

	if(NumAllChars > 8)
	{
		len += format(charMenu[len], 1800-len, "^n\r9. \wMore Characters^n");
		charKeys |= (1<<8);
	}
	else
		len += format(charMenu[len], 1800-len, "^n^n");

	// Cancel
	len += format(charMenu[len], 1800-len, "\r0. \wCancel");
	charKeys |= (1<<9);

	show_menu(id, charKeys, charMenu, -1, "Choose Character");

	return PLUGIN_HANDLED;
}

public ChooseCharacter(id, key)
{
	if(key == 8)
	{
		ShowCharacter(id, characterMenuOffset[id] + 8);
		return PLUGIN_HANDLED;
	}
	if(key == 9)
	{
		characterMenuOffset[id] = 0;
		return PLUGIN_HANDLED;
	}

	key += characterMenuOffset[id];

	if(PlayerChar[id] == key)
	{
		if(NewPlayerChar[id] != -1)
			NewPlayerChar[id] = -1;

		return PLUGIN_HANDLED;
	}

	if(PlayerChar[id] == 0)
	{
		PlayerChar[id] = key;

		InitCharacter(id);
		ShowLevel(id);
		return PLUGIN_CONTINUE;
	}
	else
		NewPlayerChar[id] = key;

	new tmp[55]
	format(tmp, 54, "You will change to %s next round", AllChars[key]);
	Nintendo_StatusHUD(id, tmp, 1);

	return PLUGIN_CONTINUE;
}
// Choosing Skills
public ShowSkill(id)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	new player = PlayerChar[id];

	new skillMenu[1801];
	new powerKeys;
	new bool:lowskills_maxed = false;

	if(PlayerSkill1[id][player] >= 3 && PlayerSkill2[id][player] >= 3 && PlayerSkill3[id][player] >= 3)
		lowskills_maxed = true;

	new len = format(skillMenu, 1800, "\rNintendo Mod^n");
	len += format(skillMenu[len], 1800-len, "\y%s Menu^n", AllChars[player]);
	len += format(skillMenu[len], 1800-len, "\y1st Passive: %s^n", AllPassive[player]);
	len += format(skillMenu[len], 1800-len, "\y2nd Passive: %s^n", AllPassive2[player]);

	if(PlayerSkill1[id][player]  < 3)
	{
		len += format(skillMenu[len], 1800-len, "^n\r1. \w%s - Level %d", AllSkill1[player], PlayerSkill1[id][player]);
		powerKeys |= MENU_KEY_1;
	}
	else if(PlayerSkill1[id][player]  < 4 && PlayerLevel[id][player] > 10 && lowskills_maxed)
	{
		len += format(skillMenu[len], 1800-len, "^n\r1. \w%s - Level %d", AllSkill1[player], PlayerSkill1[id][player]);
		powerKeys |= MENU_KEY_1;
	}
	if(PlayerSkill2[id][player]  < 3)
	{
		len += format(skillMenu[len], 1800-len, "^n\r2. \w%s - Level %d", AllSkill2[player], PlayerSkill2[id][player]);
		powerKeys |= MENU_KEY_2;
	}
	else if(PlayerSkill2[id][player]  < 4 && PlayerLevel[id][player] > 10 && lowskills_maxed)
	{
		len += format(skillMenu[len], 1800-len, "^n\r2. \w%s - Level %d", AllSkill2[player], PlayerSkill2[id][player]);
		powerKeys |= MENU_KEY_2;
	}
	if(PlayerSkill3[id][player]  < 3)
	{
		len += format(skillMenu[len], 1800-len, "^n\r3. \w%s - Level %d", AllSkill3[player], PlayerSkill3[id][player]);
		powerKeys |= MENU_KEY_3;
	}
	else if(PlayerSkill3[id][player]  < 4 && PlayerLevel[id][player] > 10 && lowskills_maxed)
	{
		len += format(skillMenu[len], 1800-len, "^n\r3. \w%s - Level %d", AllSkill3[player], PlayerSkill3[id][player]);
		powerKeys |= MENU_KEY_3;
	}
	if(PlayerLevel[id][player] >= 6 && PlayerPowerUp[id][player] < 1)
	{
		len += format(skillMenu[len], 1800-len, "^n\r4. \wPower Up: %s", AllPowerUp[player]);
		powerKeys |= MENU_KEY_4;
	}
	else if(PlayerLevel[id][player] >= 12 && PlayerPowerUp[id][player] < 2 && lowskills_maxed)
	{
		len += format(skillMenu[len], 1800-len, "^n\r4. \wPower Up: %s", AllPowerUp[player]);
		powerKeys |= MENU_KEY_4;
	}
	else if(PlayerLevel[id][player] >= 15 && PlayerPowerUp[id][player] < 3 && lowskills_maxed)
	{
		len += format(skillMenu[len], 1800-len, "^n\r4. \wPower Up: %s", AllPowerUp[player]);
		powerKeys |= MENU_KEY_4;
	}

	len += format(skillMenu[len], 1800-len, "^n^n\r0. \wExit");
	powerKeys |= MENU_KEY_0;

	show_menu(id, powerKeys, skillMenu, -1, "Choose Skill");

	return PLUGIN_CONTINUE;
}

public ChooseSkill(id, key)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	new player = PlayerChar[id];
	new tmp[55];

	switch(key)
	{
		case 0:
		{
			PlayerSkill1[id][player]++;
			format(tmp, 54, "You have selected %s", AllSkill1[player]);
			Nintendo_StatusHUD(id, tmp, 1);
			InitSkill(id, 2, PlayerSkill1[id][player]);
		}
		case 1:
		{
			PlayerSkill2[id][player]++;
			format(tmp, 54, "You have selected %s", AllSkill2[player]);
			Nintendo_StatusHUD(id, tmp, 1);
			InitSkill(id, 3, PlayerSkill2[id][player]);
		}
		case 2:
		{
			PlayerSkill3[id][player]++;
			format(tmp, 54, "You have selected %s",  AllSkill3[player]);
			Nintendo_StatusHUD(id, tmp, 1);
			InitSkill(id, 4, PlayerSkill3[id][player]);
		}
		case 3:
		{
			PlayerPowerUp[id][player]++;
			format(tmp, 54, "You have selected %s", AllPowerUp[player]);
			Nintendo_StatusHUD(id, tmp, 1);
			InitSkill(id, 5, PlayerPowerUp[id][player]);
		}
		case 9: return PLUGIN_HANDLED;
	}

	new skillsused = PlayerSkill1[id][player] + PlayerSkill2[id][player] + PlayerSkill3[id][player] + PlayerPowerUp[id][player]
	if(skillsused < PlayerLevel[id][player])
		ShowSkill(id);

	SaveXP(id);

	return PLUGIN_CONTINUE;
}
// Adding XP (only if enough players online)
public CheckEnoughPlayers()
{
	new players[32], num, player;
	new ct_num, t_num;
	ct_num = t_num = 0;

	get_players(players, num);
	for(new i = 0; i <= num; i++)
	{
		player = players[i];
		if(get_user_team(player) == 2) // Counter-Terrorist
			ct_num++;
		else if(get_user_team(player) == 1) // Terrorist
			t_num++;
		if (ct_num && t_num && ct_num + t_num >= NINTENDO_MINPLAYERS)
			return 1;
	}

	return 0;
}

public AddXP(id, xp)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	new playchar = PlayerChar[id];

	PlayerXP[id][playchar] += xp;

	new oldLevel = PlayerLevel[id][playchar];

	if(PlayerXP[id][playchar] < LEVELS[0])
		PlayerLevel[id][playchar] = 0;
	else if(PlayerXP[id][playchar] >= LEVELS[0] && PlayerXP[id][playchar] < LEVELS[1])
		PlayerLevel[id][playchar] = 1;
	else if(PlayerXP[id][playchar] >= LEVELS[1] && PlayerXP[id][playchar] < LEVELS[2])
		PlayerLevel[id][playchar] = 2;
	else if(PlayerXP[id][playchar] >= LEVELS[2] && PlayerXP[id][playchar] < LEVELS[3])
		PlayerLevel[id][playchar] = 3;
	else if(PlayerXP[id][playchar] >= LEVELS[3] && PlayerXP[id][playchar] < LEVELS[4])
		PlayerLevel[id][playchar] = 4;
	else if(PlayerXP[id][playchar] >= LEVELS[4] && PlayerXP[id][playchar] < LEVELS[5])
		PlayerLevel[id][playchar] = 5;
	else if(PlayerXP[id][playchar] >= LEVELS[5] && PlayerXP[id][playchar] < LEVELS[6])
		PlayerLevel[id][playchar] = 6;
	else if(PlayerXP[id][playchar] >= LEVELS[6] && PlayerXP[id][playchar] < LEVELS[7])
		PlayerLevel[id][playchar] = 7;
	else if(PlayerXP[id][playchar] >= LEVELS[7] && PlayerXP[id][playchar] < LEVELS[8])
		PlayerLevel[id][playchar] = 8;
	else if(PlayerXP[id][playchar] >= LEVELS[8] && PlayerXP[id][playchar] < LEVELS[9])
		PlayerLevel[id][playchar] = 9;
	else if(PlayerXP[id][playchar] >= LEVELS[9] && PlayerXP[id][playchar] < LEVELS[10])
		PlayerLevel[id][playchar] = 10;
	else if(PlayerXP[id][playchar] >= LEVELS[10] && PlayerXP[id][playchar] < LEVELS[11])
		PlayerLevel[id][playchar] = 11;
	else if(PlayerXP[id][playchar] >= LEVELS[11] && PlayerXP[id][playchar] < LEVELS[12])
		PlayerLevel[id][playchar] = 12;
	else if(PlayerXP[id][playchar] >= LEVELS[12] && PlayerXP[id][playchar] < LEVELS[13])
		PlayerLevel[id][playchar] = 13;
	else if(PlayerXP[id][playchar] >= LEVELS[13] && PlayerXP[id][playchar] < LEVELS[14])
		PlayerLevel[id][playchar] = 14;
	else if(PlayerXP[id][playchar] >= LEVELS[14])
		PlayerLevel[id][playchar] = 15;

	if(oldLevel != PlayerLevel[id][playchar])
		InitLevel(id);

	CheckSkills(id);

	return PLUGIN_CONTINUE;
}

public AddTeamXP(CsTeams:team, xp, objective[], exceptId)
{
	new players[32], num, player;
	get_players(players, num);
	for(new i = 0; i <= num; i++)
	{
		player = players[i];
		if(player == exceptId)
			continue;
		if(Nintendo_IsValidPlayer(player) && cs_get_user_team(player) == team)
		{
			client_print(player, print_chat, objective);
			AddXP(player, xp);
		}
	}

	return PLUGIN_CONTINUE;
}

public XP_Configure()
{
	wpn_multiplier[CSW_USP]			= 2.5;
	wpn_multiplier[CSW_DEAGLE]		= 2.5;
	wpn_multiplier[CSW_GLOCK18]		= 2.5;
	wpn_multiplier[CSW_ELITE]		= 3.5;
	wpn_multiplier[CSW_P228]		= 2.5;
	wpn_multiplier[CSW_FIVESEVEN]		= 2.5;

	wpn_multiplier[CSW_XM1014]		= 1.25;
	wpn_multiplier[CSW_M3]			= 1.5;

	wpn_multiplier[CSW_MP5NAVY]		= 1.25;
	wpn_multiplier[CSW_UMP45]		= 1.5;
	wpn_multiplier[CSW_P90]			= 1.5;
	wpn_multiplier[CSW_TMP]			= 1.75;
	wpn_multiplier[CSW_MAC10]		= 1.75;
	wpn_multiplier[CSW_GALIL]		= 1.15;
	wpn_multiplier[CSW_FAMAS]		= 1.15;

	wpn_multiplier[CSW_AWP]			= 1.0;
	wpn_multiplier[CSW_M4A1]		= 1.0;
	wpn_multiplier[CSW_AK47]		= 1.0;
	wpn_multiplier[CSW_AUG]			= 1.0;
	wpn_multiplier[CSW_SG552]		= 1.0;
	wpn_multiplier[CSW_G3SG1]		= 0.5;
	wpn_multiplier[CSW_SG550]		= 0.5;
	wpn_multiplier[CSW_M249]		= 1.25;
	wpn_multiplier[CSW_SCOUT]		= 3.0;

	wpn_multiplier[CSW_HEGRENADE]		= 2.0;
	wpn_multiplier[CSW_KNIFE]		= 5.0;

	wpn_multiplier[CSW_C4]			= 2.0;
	wpn_multiplier[CSW_SMOKEGRENADE]	= 1.0;
	wpn_multiplier[CSW_FLASHBANG]		= 1.0;

	return PLUGIN_CONTINUE;
}

public on_CTWin()
{
	XP_WinRound(CS_TEAM_CT);
	return PLUGIN_CONTINUE;
}

public on_TerroristWin()
{
	XP_WinRound(CS_TEAM_T);
	return PLUGIN_CONTINUE;
}

public XP_WinRound(CsTeams:WinnerTeam)
{
	
	new players[32], numberofplayers, id;
	get_players(players, numberofplayers);

	if(numberofplayers <= 1)
		return PLUGIN_CONTINUE;

	for (new i = 0; i < numberofplayers; i++)
	{
		id = players[i];
		if (cs_get_user_team(id) == WinnerTeam)
		{
			AddXP(id, 20);
			client_print(id, print_chat, "[Nintendo Mod] You just earned 20XP for winning the round");
		}
		else
			kills[id] = 0;
	}

	return PLUGIN_CONTINUE;
}

public SetLevel(id, level)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	new playchar = PlayerChar[id];
	new oldLevel = PlayerLevel[id][playchar];

	PlayerXP[id][playchar] = LEVELS[level-1];
	PlayerLevel[id][playchar] = level;

	if(oldLevel != PlayerLevel[id][playchar])
		InitLevel(id);

	CheckSkills(id)

	return PLUGIN_CONTINUE;
}

public SkillsOver(id)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	new playchar = PlayerChar[id];

	new skillsused = PlayerSkill1[id][playchar] + PlayerSkill2[id][playchar] + PlayerSkill3[id][playchar] + PlayerPowerUp[id][playchar];
	if(skillsused <= PlayerLevel[id][playchar])
		return PLUGIN_HANDLED;

	if(PlayerSkill1[id][playchar] > 0)
		PlayerSkill1[id][playchar]--;
	else if(PlayerSkill2[id][playchar] > 0)
		PlayerSkill2[id][playchar]--;
	else if(PlayerSkill3[id][playchar] > 0)
		PlayerSkill3[id][playchar]--;
	else if(PlayerLevel[id][playchar] < 6)
	{
		if(PlayerPowerUp[id][playchar])
			PlayerPowerUp[id][playchar] = 0;
	}
	else if(PlayerLevel[id][playchar] >= 6 && PlayerLevel[id][playchar] < 12)
	{
		if(PlayerPowerUp[id][playchar] > 1)
			PlayerPowerUp[id][playchar] = 1;
	}
	else if(PlayerLevel[id][playchar] >= 12 && PlayerLevel[id][playchar] < 15)
	{
		if(PlayerPowerUp[id][playchar] > 2)
			PlayerPowerUp[id][playchar] = 2;
	}

	CheckSkills(id);

	InitCharacter(id);

	return PLUGIN_CONTINUE;
}

public CheckSkills(id)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	new playchar = PlayerChar[id];

	new skillsused = PlayerSkill1[id][playchar] + PlayerSkill2[id][playchar] + PlayerSkill3[id][playchar] + PlayerPowerUp[id][playchar];
	if(skillsused < PlayerLevel[id][playchar])
		ShowSkill(id);
	else if(skillsused > PlayerLevel[id][playchar])
		SkillsOver(id);

	return PLUGIN_CONTINUE;
}
// Client Commands
public TimerAll()
{
	if(!Nintendo_Active())
		return PLUGIN_HANDLED;

	PowerUpTimer();

	return PLUGIN_CONTINUE;
}

public PowerUpTimer()
{
	if(!Nintendo_Active())
		return PLUGIN_HANDLED;

	new players[32], num, id;
	get_players(players, num);
	for(new i = 0; i <= num; i++)
	{
		id = players[i];
		if(Nintendo_IsValidPlayer(id, true))
		{
			if(PowerUpTime[id] > 0 && PlayerPowerUp[id][PlayerChar[id]])
				PowerUpTime[id]--;
			else if(PowerUpTime[id] == 0 && PlayerPowerUp[id][PlayerChar[id]])
			{
				if(!PowerUpUsed[id])
					continue;

				PowerUpUsed[id] = false;
				Nintendo_StatusHUD(id, "PowerUp Ready.", 1);
				client_cmd(id, "play nintendomod/powerup.wav")
			}
		}
	}

	return PLUGIN_CONTINUE;
}

public PowerUpKeyDown(id)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id, true) || BetweenRounds)
		return PLUGIN_HANDLED;

	if(!PowerUpUsed[id] && PowerUpTime[id] == 0 && PlayerPowerUp[id][PlayerChar[id]])
	{
		if(!equali(AllKeyDown[PlayerChar[id]], ""))
			server_cmd("%s %d", AllKeyDown[PlayerChar[id]], id);
	}
	else if(PowerUpUsed[id] && PowerUpTime[id] > 0 && PlayerPowerUp[id][PlayerChar[id]])
	{
		new temp[55];
		format(temp, 54, "PowerUp not ready.^n(%d seconds remaining)", PowerUpTime[id]);
		Nintendo_StatusHUD(id, temp, 1);
		client_cmd(id, "play nintendomod/powerupfail.wav");
	}
	else if(PlayerPowerUp[id][PlayerChar[id]] == 0)
	{
		Nintendo_StatusHUD(id, "PowerUp not available.", 1);
		client_cmd(id, "play nintendomod/powerupfail.wav");
	}

	return PLUGIN_HANDLED;
}

public PowerUpKeyUp(id)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id, true) || BetweenRounds)
		return PLUGIN_HANDLED;

	if(!PowerUpUsed[id] && PowerUpTime[id] == 0 && PlayerPowerUp[id][PlayerChar[id]] >= 1)
	{
		if(!equali(AllKeyUp[PlayerChar[id]], ""))
			server_cmd("%s %d", AllKeyUp[PlayerChar[id]], id);
	}

	return PLUGIN_HANDLED;
}

public HandleSay(id)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_CONTINUE;

	new say[31];
	read_argv(1, say, 30);
	remove_quotes(say);

	if(equali(say, "/changechar") || equali(say, "changechar") || equali(say, "/changerace") || equali(say, "changerace"))
		ShowCharacter(id, 0);
	else if(equali(say, "/selectskills") || equali(say, "selectskills"))
		CheckSkills(id);
	else if(equali(say, "/resetskills") || equali(say, "resetskills"))
		SetResetSkills(id);
	else if(equali(say, "/playerlevels") || equali(say, "playerlevels"))
		PlayerLevels(id);
	else if(equali(say, "/playerskills") || equali(say, "playerskills"))
		PlayerSkills(id);
	else if(equali(say, "/skillsinfo") || equali(say, "skillsinfo"))
		SkillsInfo(id);
	else if(equali(say, "/characterhelp") || equali(say, "characterhelp"))
		ShowCharacterHelp(id, 0);
	else if(equali(say, "/nintendomenu") || equali(say, "nintendomenu"))
		ShowNintendoMenu(id, 0);
	else if(equali(say, "/help") || equali(say, "help") || equali(say, "/nintendohelp") || equali(say, "nintendohelp"))
		PlayerHelp(id);
	else if(equali(say, "/level"))
		ShowLevel(id);
	else
		return PLUGIN_CONTINUE;

	return PLUGIN_HANDLED;
}

public PlayerLevels(id)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	new name[32], buffer[1501], temp[512];
	new len = 1500, n = 0;

	n += copy(buffer[n], len-n, MOTD_HEADER);

	for(new team = 1; team <= 2; team++)
	{
		if(team == 1)
			n += copy(buffer[n], len-n, "<h1>Terrorist:</h1>");
		else
			n += copy(buffer[n], len-n, "<h1>Counter-Terrorist:</h1>");

		new players[32], num, id;
		get_players(players, num);
		for(new i = 0; i <= num; i++)
		{
			id = players[i];
			if(Nintendo_IsValidPlayer(id))
			{
				if(get_user_team(id) == team)
				{
					get_user_name(id, name, 31);
					format(temp, 511, "%s: Character: %s - Level: %d - XP: %d<br />", name, AllChars[PlayerChar[id]], PlayerLevel[id][PlayerChar[id]], PlayerXP[id][PlayerChar[id]]);
					n += copy(buffer[n], len-n, temp);
				}
			}
		}
	}

	n += copy(buffer[n],len-n, MOTD_FOOTER);

	show_motd(id, buffer, "Nintendo Mod Characters");

	return PLUGIN_CONTINUE;
}

public PlayerSkills(id)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	new name[32], buffer[1501], temp[512];
	new len = 1500, n = 0;

	n += copy(buffer[n], len-n, MOTD_HEADER);

	for(new team = 1; team <= 2; team++)
	{
		if(team == 1)
			n += copy(buffer[n], len-n, "<h1>Terrorist:</h1>");
		else
			n += copy(buffer[n], len-n, "<h1>Counter-Terrorist:</h1>");

		new players[32], num, id;
		get_players(players, num);
		for(new i = 0; i <= num; i++)
		{
			id = players[i];
			if(Nintendo_IsValidPlayer(id))
			{
				if(get_user_team(id) == team)
				{
					get_user_name(id, name, 31);
					format(temp, 511, "%s: %s: %d - %s: %d - %s: %d - %s: %d<br />", name, AllSkill1[PlayerChar[id]], PlayerSkill1[id][PlayerChar[id]], AllSkill2[PlayerChar[id]], PlayerSkill2[id][PlayerChar[id]], AllSkill3[PlayerChar[id]], PlayerSkill3[id][PlayerChar[id]], AllPowerUp[PlayerChar[id]], PlayerPowerUp[id][PlayerChar[id]]);
					n += copy(buffer[n], len-n, temp);
				}
			}
		}
	}

	n += copy(buffer[n],len-n, MOTD_FOOTER);

	show_motd(id, buffer, "Nintendo Mod Characters");

	return PLUGIN_CONTINUE;
}

public SetResetSkills(id)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	if(!resetskills[id])
	{
		resetskills[id] = true;
		Nintendo_StatusHUD(id, "Your skills will be reset next round", 1);
	}

	return PLUGIN_CONTINUE;
}

public ResetSkills(id)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	PlayerSkill1[id][PlayerChar[id]] = 0;
	PlayerSkill2[id][PlayerChar[id]] = 0;
	PlayerSkill3[id][PlayerChar[id]] = 0;
	PlayerPowerUp[id][PlayerChar[id]] = 0;

	InitCharacter(id);

	ShowSkill(id);
	Nintendo_StatusHUD(id, "Your skills have been reset", 1);
	resetskills[id] = false;

	return PLUGIN_CONTINUE;
}

public SkillsInfo(id)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	new buffer[2001], temp[512];
	new len = 2000, n = 0;

	n += copy(buffer[n], len-n, MOTD_HEADER);

	format(temp, 511, "<h1>%s Help</h1>", AllChars[PlayerChar[id]]);
	n += copy(buffer[n], len-n, temp);

	format(temp, 511, "<h2>%s:</h2>", AllPassive[PlayerChar[id]]);
	n += copy(buffer[n], len-n, temp);
	format(temp, 511, "&nbsp&nbsp&nbsp&nbsp %s<br />", AllPassiveHelp[PlayerChar[id]]);
	n += copy(buffer[n], len-n, temp);

	format(temp, 511, "<h2>%s:</h2>", AllPassive2[PlayerChar[id]]);
	n += copy(buffer[n], len-n, temp);
	format(temp, 511, "&nbsp&nbsp&nbsp&nbsp %s<br />", AllPassive2Help[PlayerChar[id]]);
	n += copy(buffer[n], len-n, temp);

	format(temp, 511, "<h2>%s:</h2>", AllSkill1[PlayerChar[id]]);
	n += copy(buffer[n], len-n, temp);
	format(temp, 511, "&nbsp&nbsp&nbsp&nbsp %s<br />", AllSkill1Help[PlayerChar[id]]);
	n += copy(buffer[n], len-n, temp);

	format(temp, 511, "<h2>%s:</h2>", AllSkill2[PlayerChar[id]]);
	n += copy(buffer[n], len-n, temp);
	format(temp, 511, "&nbsp&nbsp&nbsp&nbsp %s<br />", AllSkill2Help[PlayerChar[id]]);
	n += copy(buffer[n], len-n, temp);

	format(temp, 511, "<h2>%s:</h2>", AllSkill3[PlayerChar[id]]);
	n += copy(buffer[n], len-n, temp);
	format(temp, 511, "&nbsp&nbsp&nbsp&nbsp %s<br />", AllSkill3Help[PlayerChar[id]]);
	n += copy(buffer[n], len-n, temp);

	format(temp, 511, "<h2>%s:</h2>", AllPowerUp[PlayerChar[id]]);
	n += copy(buffer[n], len-n, temp);
	format(temp, 511, "&nbsp&nbsp&nbsp&nbsp %s<br />", AllPowerUpHelp[PlayerChar[id]]);
	n += copy(buffer[n], len-n, temp);

	n += copy(buffer[n], len-n, MOTD_FOOTER);

	show_motd(id, buffer, "Nintendo Mod Character Help");

	return PLUGIN_CONTINUE;
}

public ShowCharacterHelp(id, menuOffset)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	characterMenuOffset[id] = 0;

	new charMenu[1801];
	new charKeys;

	if(menuOffset <= 0 || menuOffset > NumAllChars)
		menuOffset = 1;

	characterMenuOffset[id] = menuOffset;

	new len = format(charMenu, 1800, "\rNintendo Mod\r^n");
	len += format(charMenu[len], 1800-len, "\yCharacter Help^n^n");

	for(new x = menuOffset; x < menuOffset + 8; x++)
	{
		if(equali(AllChars[x], ""))
		{
			len += format(charMenu[len], 1801-len, "^n");
			continue;
		}

		len += format(charMenu[len], 1801-len, "\r%d. \w%s^n", x-menuOffset+1, AllChars[x]);

		charKeys |= (1<<x-menuOffset);
	}

	if(NumAllChars > 8)
	{
		len += format(charMenu[len], 1801-len, "^n\r9. \wMore Characters^n");
		charKeys |= (1<<8);
	}
	else
		len += format(charMenu[len], 1801-len, "^n^n");

	// Cancel
	len += format(charMenu[len], 511-len, "\r0. \wCancel");
	charKeys |= (1<<9);

	show_menu(id, charKeys, charMenu, -1, "Character Help");

	return PLUGIN_HANDLED;
}

public CharacterHelp(id, key)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	if(key == 8)
	{
		ShowCharacterHelp(id, characterMenuOffset[id] + 8);
		return PLUGIN_HANDLED;
	}
	else if(key == 9)
	{
		characterMenuOffset[id] = 0;
		return PLUGIN_HANDLED;
	}

	key += characterMenuOffset[id];

	new buffer[2001], temp[512];
	new len = 2000, n = 0;

	n += copy(buffer[n], len-n, MOTD_HEADER);

	format(temp, 511, "<h1>%s Help</h1>", AllChars[key]);
	n += copy(buffer[n], len-n, temp);

	format(temp, 511, "<h2>%s:</h2>", AllPassive[key]);
	n += copy(buffer[n], len-n, temp);
	format(temp, 511, "&nbsp&nbsp&nbsp&nbsp %s<br />", AllPassiveHelp[key]);
	n += copy(buffer[n], len-n, temp);

	format(temp, 511, "<h2>%s:</h2>", AllPassive2[key]);
	n += copy(buffer[n], len-n, temp);
	format(temp, 511, "&nbsp&nbsp&nbsp&nbsp %s<br />", AllPassive2Help[key]);
	n += copy(buffer[n], len-n, temp);

	format(temp, 511, "<h2>%s:</h2>", AllSkill1[key]);
	n += copy(buffer[n], len-n, temp);
	format(temp, 511, "&nbsp&nbsp&nbsp&nbsp %s<br />", AllSkill1Help[key]);
	n += copy(buffer[n], len-n, temp);

	format(temp, 511, "<h2>%s:</h2>", AllSkill2[key]);
	n += copy(buffer[n], len-n, temp);
	format(temp, 511, "&nbsp&nbsp&nbsp&nbsp %s<br />", AllSkill2Help[key]);
	n += copy(buffer[n], len-n, temp);

	format(temp, 511, "<h2>%s:</h2>", AllSkill3[key]);
	n += copy(buffer[n], len-n, temp);
	format(temp, 511, "&nbsp&nbsp&nbsp&nbsp %s<br />", AllSkill3Help[key]);
	n += copy(buffer[n], len-n, temp);

	format(temp, 511, "<h2>%s:</h2>", AllPowerUp[key]);
	n += copy(buffer[n], len-n, temp);
	format(temp, 511, "&nbsp&nbsp&nbsp&nbsp %s<br />", AllPowerUpHelp[key]);
	n += copy(buffer[n], len-n, temp);

	n += copy(buffer[n], len-n, MOTD_FOOTER);

	show_motd(id, buffer, "Nintendo Mod Character Help");

	return PLUGIN_CONTINUE;
}

public PlayerHelp(id)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	new buffer[1501];
	new len = 1500, n = 0;

	n += copy(buffer[n], len-n, MOTD_HEADER);

	n += copy(buffer[n], len-n, "<h2>Selecting a Character:</h2>");
	n += copy(buffer[n], len-n, "&nbsp&nbsp&nbsp&nbsp Every character has 2 Passives, 3 Skills, and 1 PowerUp<br />");
	n += copy(buffer[n], len-n, "&nbsp&nbsp&nbsp&nbsp As you level you can select a new skills<br />");
	n += copy(buffer[n], len-n, "&nbsp&nbsp&nbsp&nbsp Once you reach level 6, 12 and 15 you can increase the powerups<br />");
	n += copy(buffer[n], len-n, "&nbsp&nbsp&nbsp&nbsp All skills except the PowerUp are automatic.<br /><br />");

	n += copy(buffer[n], len-n, "<h2>How to use PowerUp:</h2>");
	n += copy(buffer[n], len-n, "&nbsp&nbsp&nbsp&nbspEvery Character has a powerup<br />");
	n += copy(buffer[n], len-n, "&nbsp&nbsp&nbsp&nbspUsage: bind ^"key^" +powerup<br />");
	n += copy(buffer[n], len-n, "&nbsp&nbsp&nbsp&nbspExample: bind z +powerup<br /><br />");

	n += copy(buffer[n], len-n, "<h2>Available Say Commands:</h2>");
	n += copy(buffer[n], len-n, "&nbsp&nbsp&nbsp&nbsp say /nintendohelp - This help menu<br />");
	n += copy(buffer[n], len-n, "&nbsp&nbsp&nbsp&nbsp say /changechar - Allows you to change your character<br />");
	n += copy(buffer[n], len-n, "&nbsp&nbsp&nbsp&nbsp say /selectskills - Allows you to select a skill<br />");
	n += copy(buffer[n], len-n, "&nbsp&nbsp&nbsp&nbsp say /resetskills - Resets your skills<br />");
	n += copy(buffer[n], len-n, "&nbsp&nbsp&nbsp&nbsp say /playerlevels - Shows you what level other players are<br />");
	n += copy(buffer[n], len-n, "&nbsp&nbsp&nbsp&nbsp say /playerskills - Shows you what skills other players have<br />");
	n += copy(buffer[n], len-n, "&nbsp&nbsp&nbsp&nbsp say /skillsinfo - Current characters skills help<br />");
	n += copy(buffer[n], len-n, "&nbsp&nbsp&nbsp&nbsp say /characterhelp - Character skills help menu<br />");

	n += copy(buffer[n], len-n, "<h2>Official Site: http://www.soloistsmodcentral.com/</h2><br />");

	n += copy(buffer[n], len-n, MOTD_FOOTER);

	show_motd(id, buffer, "Nintendo Mod Help");

	return PLUGIN_CONTINUE;
}

public ShowLevel(id)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	new len = 0, hudmsg[1801];

	if(PlayerChar[id] != 0)
	{
		new playchar = PlayerChar[id];
		len = format(hudmsg, 1800, "Character: %s^n", AllChars[playchar]);
		len += format(hudmsg[len], 1800-len, "Level: %i - XP: %i^n", PlayerLevel[id][playchar], PlayerXP[id][playchar]);
		if(PlayerLevel[id][PlayerChar[id]] > 0)
			len += format(hudmsg[len], 1800-len, "1st Passive: %s - %i^n", AllPassive[playchar], (PlayerLevel[id][playchar] > 10 ? 10 : PlayerLevel[id][playchar]));
		if(PlayerLevel[id][PlayerChar[id]] > 10)
			len += format(hudmsg[len], 1800-len, "2nd Passive: %s - %i^n", AllPassive2[playchar], PlayerLevel[id][playchar] - 10);
		if(PlayerSkill1[id][PlayerChar[id]] > 0)
			len += format(hudmsg[len], 1800-len, "Skill 1: %s - %i^n", AllSkill1[playchar], PlayerSkill1[id][playchar]);
		if(PlayerSkill2[id][PlayerChar[id]] > 0)
			len += format(hudmsg[len], 1800-len, "Skill 2: %s - %i^n", AllSkill2[playchar], PlayerSkill2[id][playchar]);
		if(PlayerSkill3[id][PlayerChar[id]] > 0)
			len += format(hudmsg[len], 1800-len, "Skill 3: %s - %i^n", AllSkill3[playchar], PlayerSkill3[id][playchar]);
		if(PlayerPowerUp[id][PlayerChar[id]] > 0)
			len += format(hudmsg[len], 1800-len, "PowerUp: %s - %i", AllPowerUp[playchar], PlayerPowerUp[id][playchar]);
	}
	else
		format(hudmsg, 1800, "You must select a character first");

	Nintendo_StatusHUD(id, hudmsg, 2);
	return PLUGIN_CONTINUE;
}

public ShowStatus(id)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	new iTarget = read_data(2);
	new iTargetTeam = get_user_team(iTarget);
	new iViewerTeam = get_user_team(id);
	new iRed = 0, iBlue = 0;
	new szTargetName[32];
	get_user_name(iTarget, szTargetName, 31);

	if(iTargetTeam == 1)
		iRed = 255;
	if(iTargetTeam == 2)
		iBlue = 255;

	set_hudmessage(iRed, 50, iBlue, -1.0, 0.60, 1, 0.01, 3.0, 0.01, 0.01, 4);

	if(iViewerTeam == iTargetTeam)
	{
		new iClip, iAmmo;
		new iWeaponID = get_user_weapon(iTarget, iClip, iAmmo);
		new szWeaponName[32];

		if(iWeaponID > 0)
			get_weaponname(iWeaponID, szWeaponName, 31);

		show_hudmessage(id, "%s -- %s - XP: %i - Level %i^n%d HP / %d AP%s%s", szTargetName, AllChars[PlayerChar[iTarget]], PlayerXP[iTarget][PlayerChar[iTarget]], PlayerLevel[iTarget][PlayerChar[iTarget]], get_user_health(iTarget), get_user_armor(iTarget), ((iWeaponID > 0) ? " / " : ""), szWeaponName);
	}
	else
		show_hudmessage(id, szTargetName);

	return PLUGIN_CONTINUE;
}

public HideStatus(id)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;


	set_hudmessage(0, 0, 0, 0.0, 0.0, 0, 0.0, 0.0, 0.0, 0.0, 4);
	show_hudmessage(id, "");

	return PLUGIN_CONTINUE;
}

public ResetXP(id, charNum)
{
	if(!Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	PlayerLevel[id][charNum] = 0;
	PlayerXP[id][charNum] = 0;
	PlayerSkill1[id][charNum] = 0;
	PlayerSkill2[id][charNum] = 0;
	PlayerSkill3[id][charNum] = 0;
	PlayerPowerUp[id][charNum] = 0;

	SaveXP(id);

	return PLUGIN_CONTINUE;
}
// Admin Commands
public Admin_GiveXP(id, level, cid)
{
	if(!cmd_access(id, level, cid, 2) || !Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	new target[33], sXP[33];

	read_argv(1, target, 32);
	read_argv(2, sXP, 32);

	new player = cmd_target(id, target, 2|8);
	if(!Nintendo_IsValidPlayer(player))
		return PLUGIN_HANDLED;

	new iXP = str_to_num(sXP);

	AddXP(player, iXP);

	new idName[54], playerName[54]
	get_user_name(id, idName, 53);
	get_user_name(player, playerName, 53);
	client_print(0, print_chat, "[Nintendo Mod] %s just gave %s %d xp", idName, playerName, iXP);

	SaveXP(player);

	return PLUGIN_HANDLED;
}

public Admin_TakeXP(id, level, cid)
{
	if(!cmd_access(id, level, cid, 2) || !Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	new target[33], sXP[33];

	read_argv(1, target, 32)
	read_argv(2, sXP, 32);

	new player = cmd_target(id, target, 2|8);
	if(!Nintendo_IsValidPlayer(player))
		return PLUGIN_HANDLED;

	new iXP = abs(str_to_num(sXP)) * -1;

	AddXP(player, iXP);

	new idName[54], playerName[54]
	get_user_name(id, idName, 53);
	get_user_name(player, playerName, 53);
	client_print(0, print_chat, "[Nintendo Mod] %s just took %d xp from %s ", idName, iXP, playerName);

	SaveXP(player);

	return PLUGIN_HANDLED;
}

public Admin_GiveLevel(id, level, cid)
{
	if(!cmd_access(id, level, cid, 2) || !Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	new target[33], sLevel[33];

	read_argv(1, target, 32)
	read_argv(2, sLevel, 32);

	new player = cmd_target(id, target, 2|8);
	if(!Nintendo_IsValidPlayer(player))
		return PLUGIN_HANDLED;

	new playerchar = PlayerChar[player]
	new iLevel = str_to_num(sLevel) + PlayerLevel[player][playerchar];

	SetLevel(player, iLevel);

	new idName[54], playerName[54]
	get_user_name(id, idName, 53);
	get_user_name(player, playerName, 53);
	client_print(0, print_chat, "[Nintendo Mod] %s just gave %d levels to %s", idName, iLevel, playerName);

	SaveXP(player);

	return PLUGIN_HANDLED;
}

public Admin_SetLevel(id, level, cid)
{
	if(!cmd_access(id, level, cid, 2) || !Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	new target[33], sLevel[33];

	read_argv(1, target, 32)
	read_argv(2, sLevel, 32);

	new player = cmd_target(id, target, 2|8);
	if(!Nintendo_IsValidPlayer(player))
		return PLUGIN_HANDLED;

	new iLevel = str_to_num(sLevel);

	SetLevel(player, iLevel);

	new idName[54], playerName[54]
	get_user_name(id, idName, 53);
	get_user_name(player, playerName, 53);
	client_print(0, print_chat, "[Nintendo Mod] %s just set %s level to %d", idName, playerName, iLevel);

	SaveXP(player);

	return PLUGIN_HANDLED;
}

public Admin_ResetXP(id, level, cid)
{
	if(!cmd_access(id, level, cid, 2) || !Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	new target[32];

	read_argv(1, target, 32)

	new player = cmd_target(id, target, 2|8);
	if(!Nintendo_IsValidPlayer(player))
		return PLUGIN_HANDLED;

	PlayerChar[player] = CLASS_NONE;

	for(new i = 1; i < MAXCHARS; i++)
	{
		PlayerLevel[player][i] = 0;
		PlayerXP[player][i] = 0;
		PlayerSkill1[player][i] = 0;
		PlayerSkill2[player][i] = 0;
		PlayerSkill3[player][i] = 0;
		PlayerPowerUp[player][i] = 0;
	}

	new idName[54], playerName[54]
	get_user_name(id, idName, 53);
	get_user_name(player, playerName, 53);
	client_print(0, print_chat, "[Nintendo Mod] %s just reset all of %s xp", idName, playerName);

	ResetXPAll(player);

	return PLUGIN_HANDLED;
}

// Natives
public native_RegisterChar(id, numParms)
{ // name, passive, passive2, skill1, skill2, skill3, powerup, init
	if(numParms != 8)
		return log_error(10, "Bad native parameters");

	if(NumAllChars == CLASS_NONE)
	{
		copy(AllChars[NumAllChars], 32, "None");
		copy(AllPassive[NumAllChars], 32, "None");
		copy(AllPassive2[NumAllChars], 32, "None");
		copy(AllSkill1[NumAllChars], 32, "None");
		copy(AllSkill2[NumAllChars], 32, "None");
		copy(AllSkill3[NumAllChars], 32, "None");
		copy(AllPowerUp[NumAllChars], 32, "None");
		copy(AllInit[NumAllChars], 32, "None");
	}

	NumAllChars++;

	new name[33], passive[33], passive2[33], skill1[33], skill2[33], skill3[33], powerup[33], init[33];

	get_string(1, name, 32);
	get_string(2, passive, 32);
	get_string(3, passive2, 32);
	get_string(4, skill1, 32);
	get_string(5, skill2, 32);
	get_string(6, skill3, 32);
	get_string(7, powerup, 32);
	get_string(8, init, 32);

	copy(AllChars[NumAllChars], 32, name);
	copy(AllPassive[NumAllChars], 32, passive);
	copy(AllPassive2[NumAllChars], 32, passive2);
	copy(AllSkill1[NumAllChars], 32, skill1);
	copy(AllSkill2[NumAllChars], 32, skill2);
	copy(AllSkill3[NumAllChars], 32, skill3);
	copy(AllPowerUp[NumAllChars], 32, powerup);
	copy(AllInit[NumAllChars], 32, init);

	return PLUGIN_CONTINUE;
}

public native_RegisterHelp(id, numParms)
{ // charName, passiveHelp, passive2Help, skill1Help, skill2Help, skill3Help, powerupHelp
	if(numParms != 7)
		return log_error(10, "Bad native parameters");

	if(NumAllChars == CLASS_NONE)
	{
		copy(AllPassiveHelp[NumAllChars], 32, "None");
		copy(AllPassive2Help[NumAllChars], 32, "None");
		copy(AllSkill1Help[NumAllChars], 32, "None");
		copy(AllSkill2Help[NumAllChars], 32, "None");
		copy(AllSkill3Help[NumAllChars], 32, "None");
		copy(AllPowerUpHelp[NumAllChars], 32, "None");
	}

	NumAllHelp++;

	new charName[33], passiveHelp[512], passive2Help[512], skill1Help[512], skill2Help[512], skill3Help[512], powerupHelp[512];

	get_string(1, charName, 32);
	get_string(2, passiveHelp, 511);
	get_string(3, passive2Help, 511);
	get_string(4, skill1Help, 511);
	get_string(5, skill2Help, 511);
	get_string(6, skill3Help, 511);
	get_string(7, powerupHelp, 511);

	for(new i = 0; i <= NumAllChars; i++)
	{
		if(equali(charName, AllChars[i]))
		{
			copy(AllPassiveHelp[NumAllHelp], 511, passiveHelp);
			copy(AllPassive2Help[NumAllHelp], 511, passive2Help);
			copy(AllSkill1Help[NumAllHelp], 511, skill1Help);
			copy(AllSkill2Help[NumAllHelp], 511, skill2Help);
			copy(AllSkill3Help[NumAllHelp], 511, skill3Help);
			copy(AllPowerUpHelp[NumAllHelp], 511, powerupHelp);
		}
	}

	return PLUGIN_CONTINUE;
}

public native_RegisterKeyDown(id, numParms)
{ // CharName, KeyDown
	if(numParms != 2)
		return log_error(10, "Bad native parameters");

	new charName[33], keyDown[33];

	get_string(1, charName, 32);
	get_string(2, keyDown, 32);

	for(new i = 0; i <= NumAllChars; i++)
	{
		if(equali(charName, AllChars[i]))
			copy(AllKeyDown[i], 32, keyDown);
	}

	return PLUGIN_CONTINUE;
}
public native_RegisterKeyUp(id, numParms)
{ // CharName, KeyUp
	if(numParms != 1)
		return log_error(10, "Bad native parameters");

	new charName[33], keyUp[33];

	get_string(1, charName, 32);
	get_string(2, keyUp, 32);

	for(new i = 0; i <= NumAllChars; i++)
	{
		if(equali(charName, AllChars[i]))
			copy(AllKeyUp[i], 32, keyUp);
	}

	return PLUGIN_CONTINUE;
}

public native_GetUserChar(id, numParms)
{ // id, class[], len
	if(numParms != 3)
		return log_error(10, "Bad native parameters");

	new player = get_param(1);

	if(!Nintendo_IsValidPlayer(player))
		return PLUGIN_HANDLED;

	set_string(2, AllChars[PlayerChar[player]], get_param(3));

	return PLUGIN_CONTINUE;
}

public native_PowerUpUsed(id, numParms)
{ // id, powerUpUsed, coolDownTime
	if(numParms != 3)
		return log_error(10, "Bad native parameters");

	new id = get_param(1);
	new powerUpUsed = get_param(2);
	new coolDownTime = get_param(3);

	if(powerUpUsed == 1)
	{
		PowerUpUsed[id] = true;
		PowerUpTime[id] = coolDownTime;
	}

	return PLUGIN_CONTINUE;
}

public native_PowerUpDeny(id, numParms)
{ // id, msg[]
	if(numParms != 2)
		return log_error(10, "Bad native parameters");

	new id = get_param(1);
	new msg[55];
	get_string(2, msg, 54);

	client_cmd(id, "play nintendomod/powerupdeny.wav");
	Nintendo_StatusHUD(id, msg, 1);

	return PLUGIN_CONTINUE;
}

public native_ExtraDamage(id, numParms)
{ // attacker, victim, damage, weaponDescription[], headshot, dmgType = DMG_BULLET, ff = -1
	if(numParms != 7)
		return log_error(10, "Bad native parameters");

	new attacker = get_param(1);
	new victim = get_param(2);
	new damage = get_param(3);
	new weaponDescription[32];
	get_string(4, weaponDescription, 31);
	new headshot = get_param(5);
	new dmgType = get_param(6);
	new FFon = get_param(7);
	if(FFon == -1) FFon = get_cvar_num("mp_friendlyfire");
	if(!Nintendo_IsValidPlayer(victim, true) || !Nintendo_IsValidPlayer(attacker)) return PLUGIN_HANDLED;
	if(pev(victim, pev_takedamage) == 0.0) return PLUGIN_HANDLED;
	if(damage <= 0) return PLUGIN_HANDLED;

	if(attacker != victim)
		DamageDone[victim][attacker] += damage;

	new Float:flNewDamage = float(damage) * 0.2;
	new Float:flArmor = (float(damage) - flNewDamage) * 0.5;
	new armortype = pev(victim, pev_armortype);
	new plrArmor = pev(victim, pev_armorvalue);

	if(flArmor > float(plrArmor))
	{
		flArmor = float(plrArmor);
		flArmor *= 2;
		flNewDamage = float(damage) - flArmor;
		plrArmor = 0;
	}
	else
		plrArmor = floatround(plrArmor - flArmor);

	new userHealth = pev(victim, pev_health);
	if(userHealth - damage <= 0 )
	{
		new bool:kill = false;
		new Float:frags;
		pev(attacker, pev_frags, frags);

		if(victim == attacker)
			kill = true;
		else if(FFon && get_user_team(victim) == get_user_team(attacker))
		{
			kill = true;
			set_pev(attacker, pev_frags, floatsub(frags, 1.0));
			client_print(attacker, print_center, "You killed a teammate");
			new money = cs_get_user_money(attacker);
			if(money != 0) cs_set_user_money(attacker, money - 150, 1);
		}
		else if(get_user_team(victim) != get_user_team(attacker))
		{
			kill = true;
			set_pev(attacker, pev_frags, floatadd(frags, 1.0));
			new money = cs_get_user_money(attacker);
			if(money < 16000) cs_set_user_money(attacker, money + 300, 1);
		}

		if(!kill) return PLUGIN_HANDLED;

		new Float:streak_multiplier = 1.0;
		if(UltimateStreak)
		{
			kills[attacker] += 1;
			kills[victim] = 0;
			deaths[attacker] = 0;
			deaths[victim] += 1;
			streak_multiplier = floatpower(1.02, float(kills[attacker] - 1));

			for(new i=0; i<STREAKLEVELS; i++)
				if (kills[attacker] == streaklevels[i])
				{
					announce(attacker, i);
					break;
				}
		}

		new Float:hs_multiplier = (headshot ? 1.5 : 1.0);
		new Float:weapon_multiplier;
		if(equal(weaponDescription, "Star") || equal(weaponDescription, "Shell Slide") || equal(weaponDescription, "Fireball") || equal(weaponDescription, "Egg Mine"))
			weapon_multiplier = 1.0;
		else
		{
			new clip, ammo, weapon = get_user_weapon(attacker, clip, ammo);
			weapon_multiplier = wpn_multiplier[weapon];
		}
		new Float:multiplier = streak_multiplier * hs_multiplier * weapon_multiplier;
		new experience = floatround(float(XPGIVEN[PlayerLevel[victim][PlayerChar[victim]]]) * multiplier);
		if(PlayerLevel[attacker][PlayerChar[attacker]] >= 10)
			experience = floatround(float(experience) * (1.0 - (PlayerLevel[attacker][PlayerChar[attacker]]-9)*0.04), floatround_floor);
		AddXP(attacker, experience);
		client_print(attacker, print_console, "[Nintendo Mod] %d XP for a kill (streak: %d kills >> +%.1f%s, weapon: +%d%s%s)", experience, kills[attacker], 100*(streak_multiplier-1), "%%", floatround(100*(weapon_multiplier-1)), "%%", (headshot ? ", hs: +50%%" : ""));

		gBlockDeathMsg = 1;
		user_kill(victim, 1);

		message_begin(MSG_ALL, get_user_msgid("DeathMsg"));
		write_byte(attacker);
		write_byte(victim);
		write_byte(headshot);
		write_string(weaponDescription);
		message_end();

		message_begin(MSG_ALL, get_user_msgid("ScoreInfo"));
		write_byte(attacker);
		write_short(get_user_frags(attacker));
		write_short(get_user_deaths(attacker));
		write_short(0);
		write_short(get_user_team(attacker));
		message_end();

		message_begin(MSG_ALL, get_user_msgid("ScoreInfo"));
		write_byte(victim);
		write_short(get_user_frags(victim));
		write_short(get_user_deaths(victim));
		write_short(0);
		write_short(get_user_team(victim));
		message_end();

	}
	else
	{
		new bool:hurt = false;
		if(victim == attacker)
			hurt = true;
		else if(FFon && get_user_team(victim) == get_user_team(attacker))
		{
			hurt = true;
			new name[33];
			get_user_name(attacker,name,32);
			client_print(0,print_chat,"%s attacked a teammate",name);
		}
		else if(get_user_team(victim) != get_user_team(attacker))
			hurt = true;

		if(!hurt)
			return 0;

		if(userHealth - damage > 0)
		{
			set_pev(victim, pev_health, float(userHealth - damage));
			set_pev(victim, pev_armorvalue, plrArmor);
			set_pev(victim, pev_armortype, armortype);
		}
		else
		{
			gBlockDeathMsg = 1;
			user_kill(victim, 1);
		}

		new aOrigin[3];
		pev(attacker, pev_origin, aOrigin);

		message_begin(MSG_ONE, get_user_msgid("Damage"), {0, 0, 0}, victim);
		write_byte(0);
		write_byte(damage);
		write_long(dmgType);
		write_coord(aOrigin[0]);
		write_coord(aOrigin[1]);
		write_coord(aOrigin[2]);
		message_end();
	}

	return PLUGIN_CONTINUE;
}
// Blocks fullupdate command
public FullUpdate(id)
{
	//This blocks "fullupdate" from resetting the HUD and doing bad things to heroes
	return PLUGIN_HANDLED
}
// Message Blocks
public hook_messagebegin(msg_dest, msg_type, Float:origin[3], ed)
{
	if(gBlockDeathMsg && msg_type == get_user_msgid("DeathMsg"))
	{
		gInBlock = 1;
		return FMRES_SUPERCEDE;
	}
	return FMRES_IGNORED
}
public hook_writebyte(value) { return (gInBlock ? FMRES_SUPERCEDE : FMRES_IGNORED); }
public hook_writechar(value) { return (gInBlock ? FMRES_SUPERCEDE : FMRES_IGNORED); }
public hook_writeshort(value) { return (gInBlock ? FMRES_SUPERCEDE : FMRES_IGNORED); }
public hook_writelong(value) { return (gInBlock ? FMRES_SUPERCEDE : FMRES_IGNORED); }
public hook_writeangle(value) { return (gInBlock ? FMRES_SUPERCEDE : FMRES_IGNORED); }
public hook_writecoord(Float:value) { return (gInBlock ? FMRES_SUPERCEDE : FMRES_IGNORED); }
public hook_writestring(sz[]) { return (gInBlock ? FMRES_SUPERCEDE : FMRES_IGNORED); }
public hook_writeent(ent) { return (gInBlock ? FMRES_SUPERCEDE : FMRES_IGNORED); }
public hook_messageend()
{
	if (gInBlock)
	{
		gInBlock = 0;
		gBlockDeathMsg = 0;
		return FMRES_SUPERCEDE;
	}
	return FMRES_IGNORED;
}
